## Shipment

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**vendor_shipment_identifier** | **string** | Unique Transportation ID created by Vendor (Should not be used over the last 365 days). |
**transaction_type** | **string** | Indicates the type of  transportation request such as (New,Cancel,Confirm and PackageLabelRequest). Each transactiontype has a unique set of operation and there are corresponding details to be populated for each operation. |
**buyer_reference_number** | **string** | The buyer Reference Number is a unique identifier generated by buyer for all Collect/WePay shipments when you submit a transportation request. This field is mandatory for Collect/WePay shipments. | [optional]
**transaction_date** | **string** | Date on which the transportation request was submitted. |
**current_shipment_status** | **string** | Indicates the current shipment status. | [optional]
**currentshipment_status_date** | **string** | Date and time when the last status was updated. | [optional]
**shipment_status_details** | [**\SellingPartnerApi\Model\VendorShippingV1\ShipmentStatusDetails[]**](ShipmentStatusDetails.md) | Indicates the list of current shipment status details and when the last update was received from carrier this is available on shipment Details response. | [optional]
**shipment_create_date** | **string** | The date and time of the shipment request created by vendor. | [optional]
**shipment_confirm_date** | **string** | The date and time of the departure of the shipment from the vendor's location. Vendors are requested to send ASNs within 30 minutes of departure from their warehouse/distribution center or at least 6 hours prior to the appointment time at the Buyer destination warehouse, whichever is sooner. Shipped date mentioned in the shipment confirmation should not be in the future. | [optional]
**package_label_create_date** | **string** | The date and time of the package label created for the shipment by buyer. | [optional]
**shipment_freight_term** | **string** | Indicates if this transportation request is WePay/Collect or TheyPay/Prepaid. This is a mandatory information. | [optional]
**selling_party** | [**\SellingPartnerApi\Model\VendorShippingV1\PartyIdentification**](PartyIdentification.md) |  |
**ship_from_party** | [**\SellingPartnerApi\Model\VendorShippingV1\PartyIdentification**](PartyIdentification.md) |  |
**ship_to_party** | [**\SellingPartnerApi\Model\VendorShippingV1\PartyIdentification**](PartyIdentification.md) |  |
**shipment_measurements** | [**\SellingPartnerApi\Model\VendorShippingV1\TransportShipmentMeasurements**](TransportShipmentMeasurements.md) |  | [optional]
**collect_freight_pickup_details** | [**\SellingPartnerApi\Model\VendorShippingV1\CollectFreightPickupDetails**](CollectFreightPickupDetails.md) |  | [optional]
**purchase_orders** | [**\SellingPartnerApi\Model\VendorShippingV1\PurchaseOrders[]**](PurchaseOrders.md) | Indicates the purchase orders involved for the transportation request. This group is an array create 1 for each PO and list their corresponding items. This information is used for deciding the route,truck allocation and storage efficiently. This is a mandatory information for Buyer performing transportation from vendor warehouse (WePay/Collect) | [optional]
**import_details** | [**\SellingPartnerApi\Model\VendorShippingV1\ImportDetails**](ImportDetails.md) |  | [optional]
**containers** | [**\SellingPartnerApi\Model\VendorShippingV1\Containers[]**](Containers.md) | A list of the items in this transportation and their associated inner container details. If any of the item detail fields are common at a carton or a pallet level, provide them at the corresponding carton or pallet level. | [optional]
**transportation_details** | [**\SellingPartnerApi\Model\VendorShippingV1\TransportationDetails**](TransportationDetails.md) |  | [optional]

[[VendorShippingV1 Models]](../) [[API list]](../../Api) [[README]](../../../README.md)
