<?php
/**
 * ListOfferMetricsRequestFilters
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for Replenishment
 *
 * The Selling Partner API for Replenishment (Replenishment API) provides programmatic access to replenishment program metrics and offers. These programs provide recurring delivery (automatic or manual) of any replenishable item at a frequency chosen by the customer.
 *
 * The version of the OpenAPI document: 2022-11-07
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\ReplenishmentV20221107;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * ListOfferMetricsRequestFilters Class Doc Comment
 *
 * @category Class
 * @description Use these parameters to filter results. Any result must match all provided parameters. For any parameter that is an array, the result must match at least one element in the provided array.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class ListOfferMetricsRequestFilters extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ListOfferMetricsRequestFilters';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'aggregation_frequency' => '\SellingPartnerApi\Model\ReplenishmentV20221107\AggregationFrequency',
        'time_interval' => '\SellingPartnerApi\Model\ReplenishmentV20221107\TimeInterval',
        'time_period_type' => '\SellingPartnerApi\Model\ReplenishmentV20221107\TimePeriodType',
        'marketplace_id' => 'string',
        'program_types' => '\SellingPartnerApi\Model\ReplenishmentV20221107\ProgramType[]',
        'asins' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'aggregation_frequency' => null,
        'time_interval' => null,
        'time_period_type' => null,
        'marketplace_id' => null,
        'program_types' => null,
        'asins' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'aggregation_frequency' => 'aggregationFrequency',
        'time_interval' => 'timeInterval',
        'time_period_type' => 'timePeriodType',
        'marketplace_id' => 'marketplaceId',
        'program_types' => 'programTypes',
        'asins' => 'asins'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'aggregation_frequency' => 'setAggregationFrequency',
        'time_interval' => 'setTimeInterval',
        'time_period_type' => 'setTimePeriodType',
        'marketplace_id' => 'setMarketplaceId',
        'program_types' => 'setProgramTypes',
        'asins' => 'setAsins'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'aggregation_frequency' => 'getAggregationFrequency',
        'time_interval' => 'getTimeInterval',
        'time_period_type' => 'getTimePeriodType',
        'marketplace_id' => 'getMarketplaceId',
        'program_types' => 'getProgramTypes',
        'asins' => 'getAsins'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['aggregation_frequency'] = $data['aggregation_frequency'] ?? null;
        $this->container['time_interval'] = $data['time_interval'] ?? null;
        $this->container['time_period_type'] = $data['time_period_type'] ?? null;
        $this->container['marketplace_id'] = $data['marketplace_id'] ?? null;
        $this->container['program_types'] = $data['program_types'] ?? null;
        $this->container['asins'] = $data['asins'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['time_interval'] === null) {
            $invalidProperties[] = "'time_interval' can't be null";
        }
        if ($this->container['time_period_type'] === null) {
            $invalidProperties[] = "'time_period_type' can't be null";
        }
        if ($this->container['marketplace_id'] === null) {
            $invalidProperties[] = "'marketplace_id' can't be null";
        }
        if ($this->container['program_types'] === null) {
            $invalidProperties[] = "'program_types' can't be null";
        }
        if ((count($this->container['program_types']) < 1)) {
            $invalidProperties[] = "invalid value for 'program_types', number of items must be greater than or equal to 1.";
        }

        if (!is_null($this->container['asins']) && (count($this->container['asins']) > 20)) {
            $invalidProperties[] = "invalid value for 'asins', number of items must be less than or equal to 20.";
        }

        if (!is_null($this->container['asins']) && (count($this->container['asins']) < 1)) {
            $invalidProperties[] = "invalid value for 'asins', number of items must be greater than or equal to 1.";
        }

        return $invalidProperties;
    }


    /**
     * Gets aggregation_frequency
     *
     * @return \SellingPartnerApi\Model\ReplenishmentV20221107\AggregationFrequency|null
     */
    public function getAggregationFrequency()
    {
        return $this->container['aggregation_frequency'];
    }

    /**
     * Sets aggregation_frequency
     *
     * @param \SellingPartnerApi\Model\ReplenishmentV20221107\AggregationFrequency|null $aggregation_frequency aggregation_frequency
     *
     * @return self
     */
    public function setAggregationFrequency($aggregation_frequency)
    {
        $this->container['aggregation_frequency'] = $aggregation_frequency;

        return $this;
    }
    /**
     * Gets time_interval
     *
     * @return \SellingPartnerApi\Model\ReplenishmentV20221107\TimeInterval
     */
    public function getTimeInterval()
    {
        return $this->container['time_interval'];
    }

    /**
     * Sets time_interval
     *
     * @param \SellingPartnerApi\Model\ReplenishmentV20221107\TimeInterval $time_interval time_interval
     *
     * @return self
     */
    public function setTimeInterval($time_interval)
    {
        $this->container['time_interval'] = $time_interval;

        return $this;
    }
    /**
     * Gets time_period_type
     *
     * @return \SellingPartnerApi\Model\ReplenishmentV20221107\TimePeriodType
     */
    public function getTimePeriodType()
    {
        return $this->container['time_period_type'];
    }

    /**
     * Sets time_period_type
     *
     * @param \SellingPartnerApi\Model\ReplenishmentV20221107\TimePeriodType $time_period_type time_period_type
     *
     * @return self
     */
    public function setTimePeriodType($time_period_type)
    {
        $this->container['time_period_type'] = $time_period_type;

        return $this;
    }
    /**
     * Gets marketplace_id
     *
     * @return string
     */
    public function getMarketplaceId()
    {
        return $this->container['marketplace_id'];
    }

    /**
     * Sets marketplace_id
     *
     * @param string $marketplace_id The marketplace identifier. The supported marketplaces for both sellers and vendors are US, CA, ES, UK, FR, IT, IN, DE and JP. The supported marketplaces for vendors only are BR, AU, MX, AE and NL. Refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids) to find the identifier for the marketplace.
     *
     * @return self
     */
    public function setMarketplaceId($marketplace_id)
    {
        $this->container['marketplace_id'] = $marketplace_id;

        return $this;
    }
    /**
     * Gets program_types
     *
     * @return \SellingPartnerApi\Model\ReplenishmentV20221107\ProgramType[]
     */
    public function getProgramTypes()
    {
        return $this->container['program_types'];
    }

    /**
     * Sets program_types
     *
     * @param \SellingPartnerApi\Model\ReplenishmentV20221107\ProgramType[] $program_types A list of replenishment program types.
     *
     * @return self
     */
    public function setProgramTypes($program_types)
    {


        if ((count($program_types) < 1)) {
            throw new \InvalidArgumentException('invalid length for $program_types when calling ListOfferMetricsRequestFilters., number of items must be greater than or equal to 1.');
        }
        $this->container['program_types'] = $program_types;

        return $this;
    }
    /**
     * Gets asins
     *
     * @return string[]|null
     */
    public function getAsins()
    {
        return $this->container['asins'];
    }

    /**
     * Sets asins
     *
     * @param string[]|null $asins A list of Amazon Standard Identification Numbers (ASINs).
     *
     * @return self
     */
    public function setAsins($asins)
    {

        if (!is_null($asins) && (count($asins) > 20)) {
            throw new \InvalidArgumentException('invalid value for $asins when calling ListOfferMetricsRequestFilters., number of items must be less than or equal to 20.');
        }
        if (!is_null($asins) && (count($asins) < 1)) {
            throw new \InvalidArgumentException('invalid length for $asins when calling ListOfferMetricsRequestFilters., number of items must be greater than or equal to 1.');
        }
        $this->container['asins'] = $asins;

        return $this;
    }
}


