<?php
/**
 * GetTrackingResult
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Amazon Shipping API
 *
 * The Amazon Shipping API is designed to support outbound shipping use cases both for orders originating on Amazon-owned marketplaces as well as external channels/marketplaces. With these APIs, you can request shipping rates, create shipments, cancel shipments, and track shipments.
 *
 * The version of the OpenAPI document: v2
 * Contact: swa-api-core@amazon.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\ShippingV2;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * GetTrackingResult Class Doc Comment
 *
 * @category Class
 * @description The payload for the getTracking operation.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class GetTrackingResult extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'GetTrackingResult';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'tracking_id' => 'string',
        'alternate_leg_tracking_id' => 'string',
        'event_history' => '\SellingPartnerApi\Model\ShippingV2\Event[]',
        'promised_delivery_date' => 'string',
        'summary' => '\SellingPartnerApi\Model\ShippingV2\TrackingSummary'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'tracking_id' => null,
        'alternate_leg_tracking_id' => null,
        'event_history' => null,
        'promised_delivery_date' => null,
        'summary' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'tracking_id' => 'trackingId',
        'alternate_leg_tracking_id' => 'alternateLegTrackingId',
        'event_history' => 'eventHistory',
        'promised_delivery_date' => 'promisedDeliveryDate',
        'summary' => 'summary'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'tracking_id' => 'setTrackingId',
        'alternate_leg_tracking_id' => 'setAlternateLegTrackingId',
        'event_history' => 'setEventHistory',
        'promised_delivery_date' => 'setPromisedDeliveryDate',
        'summary' => 'setSummary'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'tracking_id' => 'getTrackingId',
        'alternate_leg_tracking_id' => 'getAlternateLegTrackingId',
        'event_history' => 'getEventHistory',
        'promised_delivery_date' => 'getPromisedDeliveryDate',
        'summary' => 'getSummary'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['tracking_id'] = $data['tracking_id'] ?? null;
        $this->container['alternate_leg_tracking_id'] = $data['alternate_leg_tracking_id'] ?? null;
        $this->container['event_history'] = $data['event_history'] ?? null;
        $this->container['promised_delivery_date'] = $data['promised_delivery_date'] ?? null;
        $this->container['summary'] = $data['summary'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        if ($this->container['tracking_id'] === null) {
            $invalidProperties[] = "'tracking_id' can't be null";
        }
        if ($this->container['alternate_leg_tracking_id'] === null) {
            $invalidProperties[] = "'alternate_leg_tracking_id' can't be null";
        }
        if ($this->container['event_history'] === null) {
            $invalidProperties[] = "'event_history' can't be null";
        }
        if ($this->container['promised_delivery_date'] === null) {
            $invalidProperties[] = "'promised_delivery_date' can't be null";
        }
        if ($this->container['summary'] === null) {
            $invalidProperties[] = "'summary' can't be null";
        }
        return $invalidProperties;
    }


    /**
     * Gets tracking_id
     *
     * @return string
     */
    public function getTrackingId()
    {
        return $this->container['tracking_id'];
    }

    /**
     * Sets tracking_id
     *
     * @param string $tracking_id The carrier generated identifier for a package in a purchased shipment.
     *
     * @return self
     */
    public function setTrackingId($tracking_id)
    {
        $this->container['tracking_id'] = $tracking_id;

        return $this;
    }
    /**
     * Gets alternate_leg_tracking_id
     *
     * @return string
     */
    public function getAlternateLegTrackingId()
    {
        return $this->container['alternate_leg_tracking_id'];
    }

    /**
     * Sets alternate_leg_tracking_id
     *
     * @param string $alternate_leg_tracking_id The carrier generated reverse identifier for a returned package in a purchased shipment.
     *
     * @return self
     */
    public function setAlternateLegTrackingId($alternate_leg_tracking_id)
    {
        $this->container['alternate_leg_tracking_id'] = $alternate_leg_tracking_id;

        return $this;
    }
    /**
     * Gets event_history
     *
     * @return \SellingPartnerApi\Model\ShippingV2\Event[]
     */
    public function getEventHistory()
    {
        return $this->container['event_history'];
    }

    /**
     * Sets event_history
     *
     * @param \SellingPartnerApi\Model\ShippingV2\Event[] $event_history A list of tracking events.
     *
     * @return self
     */
    public function setEventHistory($event_history)
    {
        $this->container['event_history'] = $event_history;

        return $this;
    }
    /**
     * Gets promised_delivery_date
     *
     * @return string
     */
    public function getPromisedDeliveryDate()
    {
        return $this->container['promised_delivery_date'];
    }

    /**
     * Sets promised_delivery_date
     *
     * @param string $promised_delivery_date The date and time by which the shipment is promised to be delivered.
     *
     * @return self
     */
    public function setPromisedDeliveryDate($promised_delivery_date)
    {
        $this->container['promised_delivery_date'] = $promised_delivery_date;

        return $this;
    }
    /**
     * Gets summary
     *
     * @return \SellingPartnerApi\Model\ShippingV2\TrackingSummary
     */
    public function getSummary()
    {
        return $this->container['summary'];
    }

    /**
     * Sets summary
     *
     * @param \SellingPartnerApi\Model\ShippingV2\TrackingSummary $summary summary
     *
     * @return self
     */
    public function setSummary($summary)
    {
        $this->container['summary'] = $summary;

        return $this;
    }
}


